/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reachfix;

import javax.annotation.Nullable;
import meldexun.configutil.ConfigUtil;
import meldexun.reachfix.config.ReachFixConfig;
import meldexun.reachfix.network.CPacketHandlerSyncConfig;
import meldexun.reachfix.network.SPacketSyncConfig;
import meldexun.reachfix.util.ReachFixUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="reachfix")
public class ReachFix {
    public static final String MODID = "reachfix";
    public static final Logger LOGGER = LogManager.getLogger((String)"reachfix");
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("reachfix");
    public static boolean isSpartanWeaponryInstalled;

    @Mod.EventHandler
    public void onFMLConstructionEvent(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        NETWORK.registerMessage(CPacketHandlerSyncConfig.class, SPacketSyncConfig.class, 1, Side.CLIENT);
    }

    @Mod.EventHandler
    public void onFMLPostInitializationEvent(FMLPostInitializationEvent event) {
        isSpartanWeaponryInstalled = Loader.isModLoaded((String)"spartanweaponry");
    }

    @Mod.EventHandler
    public void onFMLServerStartingEvent(FMLServerStartingEvent event) {
        ReachFix.loadLocalConfig(true);
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ReachFix.sendServerConfig((EntityPlayerMP)event.player);
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        ReachFixUtil.updateBaseReachModifier(event.player);
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
            Minecraft mc = Minecraft.func_71410_x();
            IntegratedServer server = mc.func_71401_C();
            ReachFix.loadLocalConfig(mc.field_71441_e == null || server != null);
            if (server != null) {
                ReachFix.sendServerConfig(null);
                server.func_184103_al().func_181057_v().forEach(ReachFixUtil::updateBaseReachModifier);
            }
        }
    }

    public static void loadLocalConfig(boolean loadAllSettings) {
        try {
            if (loadAllSettings) {
                ConfigUtil.copyAllSettings(ReachFixConfig.MASTER_CONFIG, ReachFixConfig.SLAVE_CONFIG);
            } else {
                ConfigUtil.copyClientSettings(ReachFixConfig.MASTER_CONFIG, ReachFixConfig.SLAVE_CONFIG);
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to copy config", (Throwable)e);
        }
    }

    public static void sendServerConfig(@Nullable EntityPlayerMP player) {
        try {
            if (player != null) {
                NETWORK.sendTo((IMessage)new SPacketSyncConfig(ReachFixConfig.MASTER_CONFIG), player);
            } else {
                NETWORK.sendToAll((IMessage)new SPacketSyncConfig(ReachFixConfig.MASTER_CONFIG));
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to send server config", (Throwable)e);
        }
    }
}

